gsap.registerPlugin(ScrollTrigger, SplitText);

gsap.registerPlugin(ScrollSmoother);

document.querySelectorAll(".sc_heading").forEach((section) => {
    const heading = section.querySelector(".heading-plain-text");

    if (!heading.dataset.splitDone) {
        new SplitText(heading, {
            type: "lines",
            linesClass: "text-lines"
        });

        heading.dataset.splitDone = "true";
    }

    ScrollTrigger.create({
        trigger: section,
        start: "top 85%",
        onEnter: () => section.classList.add("is-inview"),
        // onLeaveBack: () => section.classList.remove("is-inview")
    });
});
document.querySelectorAll(".ui-advanced-products").forEach((section) => {
    ScrollTrigger.create({
        trigger: section,
        start: "top 85%",
        onEnter: () => section.classList.add("is-inview"),
        // onLeaveBack: () => section.classList.remove("is-inview")
    });
});
const backToTopEl = document.getElementById("templaza-backtotop-element");
window.addEventListener("scroll", () => {
    const scrollTop = window.scrollY || document.documentElement.scrollTop;
    const windowHeight = window.innerHeight;
    const docHeight = document.documentElement.scrollHeight;

    const distanceToBottom = docHeight - (scrollTop + windowHeight);

    const backToTop = document.getElementById("templaza-backtotop");

    if (distanceToBottom < 400) {
        backToTop.classList.add("uk-hidden");
    } else {
        backToTop.classList.remove("uk-hidden");
    }
});

if (document.querySelector('.bg-image-motion')) {
    const container = document.querySelector('.bg-image-motion');

    let mouseX = 0;
    let mouseY = 0;
    let rect = container.getBoundingClientRect();
    let isHovering = false;

    container.addEventListener('mouseenter', () => {
        rect = container.getBoundingClientRect();
        isHovering = true;
    });

    container.addEventListener('mousemove', (e) => {
        mouseX = e.clientX - rect.left;
        mouseY = e.clientY - rect.top;
    });

    container.addEventListener('mouseleave', () => {
        isHovering = false;
        container.style.backgroundPosition = 'center';
    });

    function animate() {
        if (isHovering) {
            const percentX = (mouseX / rect.width - 0.5) * 15;
            const percentY = (mouseY / rect.height - 0.5) * 15;
            container.style.backgroundPosition = `${50 + percentX}% ${50 + percentY}%`;
        }

        requestAnimationFrame(animate);
    }

    animate();
}


const thumbnails = document.querySelectorAll('.tz-img, .product-thumbnails--hover, .el-item');

thumbnails.forEach(thumbnail => {
    let currentX = 0, currentY = 0;
    let targetX = 0, targetY = 0;
    let rafId = null;

    function animate() {
        currentX += (targetX - currentX) * 0.1;
        currentY += (targetY - currentY) * 0.1;

        thumbnail.style.transform = `translate(${currentX}px, ${currentY}px)`;

        if (Math.abs(targetX - currentX) > 0.1 || Math.abs(targetY - currentY) > 0.1) {
            rafId = requestAnimationFrame(animate);
        } else {
            rafId = null;
        }
    }

    thumbnail.addEventListener('mousemove', (e) => {
        const rect = thumbnail.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;

        targetX = (x / rect.width - 0.5) * 20;
        targetY = (y / rect.height - 0.5) * 20;

        if (!rafId) {
            animate();
        }
    });

    thumbnail.addEventListener('mouseleave', () => {
        targetX = 0;
        targetY = 0;
        if (!rafId) {
            animate();
        }
    });
});
